#!perl
use Config;
use File::Basename qw(&basename &dirname);
use File::Spec;
use FindBin '$Bin';
use Cwd;

my %OPTIONS;
if (open F,"$Bin/../BioXRT.def") {
  while (<F>) {
    next if /^\#/;
    chomp;
    $OPTIONS{$1} = $2 if /^(\w+)\s*=\s*(.+)/;
  }
  close F;
}
my $CONF_DIR = $OPTIONS{CONF} ? "$OPTIONS{CONF}/bioxrt.conf" : "";
$OPTIONS{VERSION} ||= '1.00';

my $dir = dirname($0);
$file   = shift || File::Spec->catfile($dir,basename($0, '.PL','.PLS'));

open OUT,">$file" or die "Can't create $file: $!";

print "Extracting $file (with variable substitutions)\n";

my $startperl = $Config{startperl} ne '#!perl' 
  ? $Config{startperl}
  : "#!$Config{perlpath}";

print OUT <<"!GROK!THIS!";
$startperl

###################################################################
# Users can change this variable if needed to point to the
# directory in which the configuration files are stored.
#
\$CONF_DIR  = '$CONF_DIR';
#
###################################################################
\$VERSION   = '$OPTIONS{VERSION}';

!GROK!THIS!

# In the following, perl variables are not expanded during extraction.

print OUT <<'!NO!SUBS!';
# $Id: tbrowse.PLS,v 1.3 2008/08/27 21:26:42 junjun Exp $

use strict;
use Bio::ConfigFile;
use Bio::DB::XRT::TBrowser;
use Bio::DB::Fasta;

use CGI qw(:standard escape escapeHTML center *table *dl *TR *td);
use CGI::Carp 'fatalsToBrowser';
use Digest::MD5 'md5_hex';

use vars qw($CONF_DIR $TBROWSE $VERSION);
use constant DEBUG => 0;


###################################################################
# if $CONF_DIR is empty before this point the setting of conf dir can
# be put in the file .tbconfidr which is at the same directory of the
# tbrowse script itself
#
if (!$CONF_DIR and (-e ".tbconfdir")) {
	my %OPTIONS = ();
	if (open F,".tbconfdir") {
	  while (<F>) {
	    next if /^\#/;
	    chomp;
	    $OPTIONS{$1} = $2 if /^(\w+)\s*=\s*(.+)/;
	  }
	  close F;
	}
	$CONF_DIR = $OPTIONS{conf_dir};
}
$CONF_DIR =~ s/^\s*//;
$CONF_DIR =~ s/$\s*//;
die "No CONF_DIR specified!" unless $CONF_DIR;
#
###################################################################


$TBROWSE ||= Bio::DB::XRT::TBrowser->new($CONF_DIR, 1) or die "Can't read configuration files: $!";

my $URL  = 'tbrowse';
$TBROWSE->url($URL);

## page settings ######################
# recovery a hashref which contains page-specific settings (this involves reading a cookie)
my ($source, $old_source, $table, $old_table) = get_source();

my $page_settings = get_settings($source, $table);


# Now adjust those settings based on submitted CGI parameters
# With the exception that we ignore parameter changes if the source has changed.
if ((defined($old_source) and $source ne $old_source) or (defined($old_table) and $table ne $old_table)){
#  if change source or table through POST method CGI parameter, don't adjust_settings, just force to show the configuration page
#  this part doesn't work properly, sort it out later
#  $page_settings->{show} = 'Conf';
} else {
  adjust_settings($page_settings);        # set settings from CGI parameters
}


my $cookies = settings2cookie($page_settings);

#print "Cache-Control: no-store, no-cache, max-age=0, must-revalidate\n";
#print "Cache-Control: post-check=0, pre-check=0\n";
#print "Pragma: no-cache\n";
print header(-expires=>'-10d', -cookie => $cookies, -charset=>'ISO-8859-1');

if (request_method eq 'HEAD') {exit 0}

## starting the page
my $bgcolor = $TBROWSE->setting('bgcolor', 'general') || 'white';
my $stylesheet = $TBROWSE->setting('stylesheet', 'general') || '';

$stylesheet = "<link href='$stylesheet' rel='stylesheet' type='text/css' />" if $stylesheet;

print "<html xmlns='http://www.w3.org/1999/xhtml' lang='en-US'>
<head>
  <title>BioXRT: Table Browser</title>
  $stylesheet
</head> 
<body text='#000088'  bgcolor='$bgcolor'>
";


my $page_header = $TBROWSE->page_header();
$page_header = &$page_header if (ref $page_header eq 'CODE');
print $page_header."<a name='top'> </a>\n";


if ($page_settings->{show} =~ /^(Conf|Reset)$/i or !($page_settings->{table})) {  # output the configuration panel

  control_panel($page_settings);

} else { # output the table

  my @cols = split /[+-]/, $page_settings->{cols};
  @cols = $TBROWSE->default_cols unless @cols;
  $TBROWSE->adjust_cols(@cols) if @cols;

  ### TODO: some more work needed here....
  my ($keyword, $operator) = @{$page_settings->{keyword}} if ref $page_settings->{keyword};
  $operator = $TBROWSE->setting('keyword match') || $TBROWSE->setting('keyword search', 'general') || 'match';  ## for now, set the keyword search operator default to 'match'

  my $keywordMinLen = $TBROWSE->setting('keyword min len') || $TBROWSE->setting('keyword min len', 'general');
  if ($keywordMinLen && ($operator eq 'match') && (length($keyword) < $keywordMinLen) &&
        (!((ref $page_settings->{filter} eq 'ARRAY') && @{$page_settings->{filter}} > 0) || length($keyword) > 0)) {
    print "<br> <font size='5' color='red'>Keyword is too short, the minimal length is $keywordMinLen.</font><br><br>\n";
    print end_html;
    exit;
  }

  $TBROWSE->keyword([$keyword,$operator]) if length $keyword > 0;

  $TBROWSE->filter($page_settings->{filter}) if (ref $page_settings->{filter} eq 'ARRAY');

  my $rstart = param('rstart');
  my $rnum   = param('rnum');  
  my $output = param('output');
  $TBROWSE->rstart($rstart) if defined $rstart;
  $TBROWSE->set_rows($rnum) if defined $rnum;
  $TBROWSE->output($output) if $output;

  print "<p><a href='".$TBROWSE->url."?show=Conf"."&source=".$TBROWSE->source."&table=".$TBROWSE->table."'>Back to Table Browser Configuration Page</a></p>\n" if $TBROWSE->show_back;

  print "<pre>\n" unless ($output=~/html/i or !$output);
  $TBROWSE->show_table;
  print "</pre>\n" unless ($output=~/html/i or !$output);
  

}

print end_html;


###############################################################################################
## sub-rountines
###############################################################################################

sub control_panel {
  my $settings = shift;
  my ($keyword, $kwd_op) = @{$settings->{keyword}} if ref $settings->{keyword};

  $TBROWSE->table($settings->{table});

  my $col_settings = $TBROWSE->view->columns;
  my @column_ids = @{ $col_settings->{cols} };

  my @selected_cols = split /[+-]/, $settings->{cols};
  @selected_cols = $TBROWSE->default_cols unless @selected_cols;
  @selected_cols = @column_ids unless @selected_cols;

  print "<h2> Table Browser </h2>";

  print "
<form method='POST' enctype='multipart/form-data' action='".$TBROWSE->url."' name='mainform'>
  <table border='0' cellpadding='0' cellspacing='0'>
    <tr>
      <td width='10' height='135' valign='top'>&nbsp;</td>
      <td width='220' height='135' valign='top'>Source:<br>
      <select size='1' name='source' onchange='document.mainform.submit()'>\n";

  foreach ($TBROWSE->sources) {
    print "<option ".($_ eq $TBROWSE->source ? "selected " : "")."value='$_'>".$TBROWSE->setting('description','general',$_)."</option>\n";
  }

  print "</select>
      <p>Keyword: <input type='text' name='keyword' size='20' value='$keyword'></p>
      <p>Tables:<br>
      <select size='14' name='table' onchange='document.mainform.submit()'>\n";

  foreach ($TBROWSE->tables) {
    my $title = $TBROWSE->setting('title',$_);
    print "<option ".($_ eq $TBROWSE->table ? "selected " : "")."value='$_'>".($title ? $title : $_)."</option>\n";
  }

  print "
      </select></p>
      </td>
      <td width='40' height='135' valign='top'>&nbsp;</td>
      <td width='320' height='135' valign='top'>Columns: (Hold Ctrl for multi-selection)<br>
      <select size='12' name='cols' multiple>\n";

  my @c_id2show = ();
  foreach (@column_ids) {
    next if /^_/;
    my $c_id = $_;
    my @selected = grep {/^$c_id$/} @selected_cols;
    my $c_id2show = $col_settings->{settings}{$c_id}{calc} ? "" : $c_id;
    push @c_id2show, $c_id2show if $c_id2show;
    print "<option ".(@selected ? "selected " : "")."value='$c_id'>$col_settings->{settings}{$c_id}{header}".($c_id2show ? " [$c_id2show]" : "")."</option>\n";
  }

  my @filters = @{$settings->{filter}} if (ref $settings->{filter} eq 'ARRAY');
  my $flop = pop @filters if (@filters > 2);
  my $flop = (ref $flop eq 'ARRAY') ? $flop->[0] : 'AND'; 

  print "
      </select>
      <p>Column Filters&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      <input type='radio' value='AND' ".(uc($flop) eq 'AND' ? 'checked' : '')." name='flop'>AND
      <input type='radio' value='OR' ".(uc($flop) eq 'OR' ? 'checked' : '')." name='flop'>OR <br>";

  my $a2show = $TBROWSE->view->a2show if (@filters);
  my @a2show = @{$a2show} if ref $a2show;
  my %get_col_id = ();
  foreach (@a2show) {
    my $rc_aid = $_->[1] . '~-~' . $_->[2];
    $get_col_id{$rc_aid} = $_->[0] unless ($_->[0] =~ /^_/);
  }

  for (my $i=0; $i<4; $i++) {
    my $rcid = $filters[$i]->[0] if (ref $filters[$i] eq 'ARRAY');
    my $aid = $filters[$i]->[1] if (ref $filters[$i] eq 'ARRAY');
    my $kwd = $filters[$i]->[2] if (ref $filters[$i] eq 'ARRAY');
    my $opt = $filters[$i]->[3] if (ref $filters[$i] eq 'ARRAY');
    my $rc_aid = $rcid . '~-~' . $aid;
    my $col_id = $get_col_id{$rc_aid};

    print "
      <select size='1' name='fcol'>
      <option value=''> </option>\n";
    foreach (@c_id2show) {
      print "<option ".($_ eq $col_id ? "selected" : "")." >$_</option>\n";
    }
    print "
      </select>
      <select size='1' name='fcomp'>
      <option ".($opt eq '=' ? "selected" : "")." >=</option>
      <option ".($opt eq 'in' ? "selected" : "")." >in</option>
      <option ".($opt eq 'rlike' ? "selected" : "")." >rlike</option>
      <option ".($opt eq '>' ? "selected" : "")." >></option>
      <option ".($opt eq '>=' ? "selected" : "")." >>=</option>
      <option ".($opt eq '<' ? "selected" : "")." ><</option>
      <option ".($opt eq '<=' ? "selected" : "")." ><=</option>
      <option ".($opt eq '<>' ? "selected" : "")." ><></option>
      </select> 
      <input name='fkwd' size='20' value='$kwd'><br>\n";
  }

print "
     </p></td>
    </tr>
    <tr>
      <td width='10' height='66'>&nbsp;</td>
      <td align='center' height='66' colspan='3'>
      <input type='submit' value='Submit' name='show'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 
      <input type='submit' value='Reset' name='show'></td>
    </tr>";

my $example_keywords = $TBROWSE->setting('keyword examples');
my @e_keywords = split /\;+/, $example_keywords;
$_ = "<a href='?keyword=$_&filter=&show=Conf'>$_</a>" foreach (@e_keywords);
$example_keywords = join(', ', @e_keywords);

my $example_filters = $TBROWSE->setting('filter examples');
my @e_filters = split /\s*\;+\s*/, $example_filters;
foreach (@e_filters) {
  my @filters = split /:/;
  my $op = 'AND';
  my $note;
  my @fcols = ();
  my @fcomps = ();
  my @fkwds = ();
  foreach (@filters) {
    my @elements = split /'/;
    if (@elements == 1 and $elements[0] =~ /^(or|and)$/i) {
      $op = $elements[0] ;
    } elsif (@elements == 1) {
      $note = $elements[0] ;
    }

    if (@elements == 3) {
      push @fcols, $elements[0];
      push @fcomps, $elements[1];
      push @fkwds, $elements[2];
    }
  }

  my $filter = "";
  my $ii = 0;
  foreach (@fcols) {
    $filter .= "&fcol=$_&fcomp=$fcomps[$ii]&fkwd=$fkwds[$ii]";
    $ii++;
  }

  $_ = "<a href='?flop=$op$filter&keyword=&show=Conf'>".($note ? $note : $_)."</a>";
}
$example_filters = join('; ', @e_filters);

print "
    <tr>
      <td width='10' height='66'>&nbsp;</td>
      <td colSpan='3' height='66'>
      <p align='left'>Examples: (Click one of the following links then click \"Submit\")<br>
        &nbsp; Keyword: $example_keywords<br>
        &nbsp; Filters: $example_filters</td>
    </tr>" if ($example_keywords or $example_filters);

print "
  </table>
<input type='hidden' name='show' value='Conf'/>
</form>
";

}

sub get_source {
  my $new_source = param('source');
  my $new_table = param('table');
  
  my %source = cookie('tbrowse_source');
  my $old_source = $source{source} unless param('source') && request_method() eq 'GET';
  my $old_table = $source{table} unless param('table') && request_method() eq 'GET';

  my $source   = $new_source || $old_source;
  $source ||= $TBROWSE->source;  # the default, whatever it is

  my $table = $new_table || $old_table;

  $TBROWSE->source($source);
  $table = $TBROWSE->default_table if ($source ne $old_source and defined($old_source));
  $table ||= $TBROWSE->default_table;
  $table = $TBROWSE->table($table);

  return ($source,$old_source,$table,$old_table);
}

# read from cookie, if there is one
# if not, set from defaults
sub get_settings {
  my $source   = shift;
  my $table   = shift;

  my %settings = cookie("tbrowse_$source:$table");

  my $ok = 1;

  if (%settings) {  # if cookie is there, then validate it
    BLOCK: {
      $ok &&= $settings{v} == $VERSION;
      warn "ok 0 = $ok" if DEBUG;
      last unless $ok;
  
      $ok &&= defined $settings{width};
      warn "ok 1 = $ok" if DEBUG;
  
      my %ok_sources = map {$_=>1} $TBROWSE->sources;
      $ok &&= $ok_sources{$settings{source}};
      warn "ok 2 = $ok" if DEBUG;
  
      $TBROWSE->source($settings{source}) if $ok;   ### not sure

      my %ok_tables = map {$_=>1} $TBROWSE->tables;
      $ok &&= $ok_tables{$settings{table}};
      warn "ok 3 = $ok" if DEBUG;
  
      $TBROWSE->table($settings{table}) if $ok;    ### not sure

      my @cols = split $;,$settings{cols} if $ok && defined $settings{cols};

      my ($keyword,$opt) = split $;,$settings{keyword} if $ok && defined $settings{keyword};
      $settings{keyword} = [$keyword,$opt];
        
      my @flat_filters = split $;,$settings{filter} if $ok && defined $settings{filter};
      my $filter = [ ];
      my $count = 0;
      foreach (@flat_filters) {
        next unless $ok;
        my @felements = split ':--:', $_;
        $ok = 0 if (($count <= 1 and @felements != 4) or ($count > 1 and @felements != 4 and @felements != 1));
        push @{$filter}, \@felements;
        $count++;
      }
      $settings{filter} = $filter;

    }
  }

  if ($ok && %settings) {
    adjust_cols(\%settings);
  }
  else {
    %settings = ();
    default_settings(\%settings);
  }

  warn "order = @{$settings{cols}}" if $settings{cols} && DEBUG;

  \%settings;
}

sub default_settings {
  my $settings = shift;
  warn "Setting default settings" if DEBUG;
  $settings->{source}  = $TBROWSE->source;
  $settings->{table}   = $TBROWSE->table;
  my @default_cols     = $TBROWSE->default_cols;
  $settings->{cols}    = join('+', @default_cols);
  $settings->{width}   = $TBROWSE->width;
  $settings->{id}      = md5_hex(rand);  # new identity
  $settings->{v}       = $VERSION;
  $settings->{show}    = 'Conf';
}

sub adjust_cols {
  my $settings = shift;

}

# this is called to change the values of the settings from CGI parameters
sub adjust_settings {
  my $settings = shift;

  my $flop = 'OR';
  my @fcols = ();
  my @fcomps = ();
  my @fkwds = ();
  $flop = param('flop') if (param('flop') =~ /^(OR|AND)$/i);
  @fcols = param('fcol');
  @fcomps = param('fcomp');
  @fkwds = param('fkwd');

  my $ii = 0;
  my $filter = [ ];
  my $all_cols = $TBROWSE->view->columns;
  foreach (@fcols) {
    my $fcol = $_;
    my $fkwd = $fkwds[$ii];
    $fkwd =~ s/\s*$//;
    $fkwd =~ s/^\s*//;
    my $fcomp = $fcomps[$ii];

    if ($fcol and length($fkwd)>0 and $fcomp) {
      my $rcid = $all_cols->{settings}{$fcol}{rcid};
      my $aid = $all_cols->{settings}{$fcol}{aid};
      my $myfilter = [$rcid,$aid,$fkwd,$fcomp];
      push @{ $filter }, $myfilter if (defined ($rcid) and defined ($aid));
    }

    $ii++;
  }

  push @{ $filter }, ["$flop"] if (@{$filter} > 1);

  $settings->{filter} = $filter if defined param('fcol');

  $settings->{filter} = undef if defined param('filter');  ### that's the way to get rid of the filter from url

  $settings->{width} = param('width') if param('width');

  if (defined param('cols')) {
    my @cols = param('cols');
    $settings->{cols} = join '+', @cols;
  }

  if (defined param('keyword')) {
    my ($keyword, $operator) = split $;, param('keyword');
    $keyword =~ s/\s*$//;
    $keyword =~ s/^\s*//;
#    $operator ||= 'match';
    $settings->{keyword} = [$keyword, $operator];
  }

  if (param('show')) {
    $settings->{show} = param('show');

    if ($settings->{show} eq 'Reset'){
      my @default_cols     = split /\s+/, $TBROWSE->setting('columns');
      $settings->{cols}    = join('+', @default_cols);
      $settings->{keyword} = "";
      $settings->{filter}  = undef;
    }
  }


}


sub settings2cookie {
  my $settings = shift;

  my %settings = %$settings;
  local $^W = 0;
  for my $key (keys %settings) {
    if (ref($settings{$key}) eq 'ARRAY') {
      if ($key eq 'filter') {
        my @filters = @{$settings{$key}};
        my @flat_filters = ();
        foreach (@filters) {
          my @filter = @{$_};
          push @flat_filters, join(':--:', @filter);
        }
        $settings{$key} = join $;, @flat_filters;
      } else {
        $settings{$key} = join $;,@{$settings{$key}};
      }
    }
  }

  my @cookies;
  my $source = $TBROWSE->source;
  my $table  = $TBROWSE->table;
  my %source = ( "source" => $source, "table" => $table);

  push @cookies,cookie(-name    => "tbrowse_$source:$table",
              -value   => \%settings,
              -expires => '+3M');
  push @cookies,cookie(-name   => 'tbrowse_source',
               -value  => \%source,
               -expires => '+3M');
  warn "cookies = @cookies" if DEBUG;

  return \@cookies;
  
}

=head1 AUTHOR

Junjun Zhang E<lt>junjun@genet.sickkids.on.caE<gt>.

Copyright (c) 2004 The Centre for Applied Genomics.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.  See DISCLAIMER for
disclaimers of warranty.

=cut

!NO!SUBS!
close OUT or die "Can't close $file: $!";
chmod 0755, $file or die "Can't reset permissions for $file: $!\n";
exec("$Config{'eunicefix'} $file") if $Config{'eunicefix'} ne ':';
