#!perl
use Config;
use File::Basename qw(&basename &dirname);
use File::Spec;
use FindBin '$Bin';
use Cwd;

my %OPTIONS;
if (open F,"$Bin/../BioXRT.def") {
  while (<F>) {
    next if /^\#/;
    chomp;
    $OPTIONS{$1} = $2 if /^(\w+)\s*=\s*(.+)/;
  }
  close F;
}
my $CONF_DIR = $OPTIONS{CONF} ? "$OPTIONS{CONF}/bioxrt.conf" : "";
$OPTIONS{VERSION} ||= '1.00';

my $dir = dirname($0);
$file   = shift || File::Spec->catfile($dir,basename($0, '.PL','.PLS'));

open OUT,">$file" or die "Can't create $file: $!";

print "Extracting $file (with variable substitutions)\n";

my $startperl = $Config{startperl} ne '#!perl' 
  ? $Config{startperl}
  : "#!$Config{perlpath}";

print OUT <<"!GROK!THIS!";
$startperl

###################################################################
# Users can change this variable if needed to point to the
# directory in which the configuration files are stored.
#
\$CONF_DIR  = '$CONF_DIR';
#
###################################################################
\$VERSION   = '$OPTIONS{VERSION}';

!GROK!THIS!

# In the following, perl variables are not expanded during extraction.

print OUT <<'!NO!SUBS!';
# $Id: xview.PLS,v 1.2 2008/08/27 21:28:36 junjun Exp $

use Bio::ConfigFile;
use Bio::DB::XRT;
use XML::Parser;
use XML::Parser::EasyTree;
use URI::Escape('uri_escape');
use CGI qw(:standard escape escapeHTML center *table *dl *TR *td);
use CGI::Carp qw(fatalsToBrowser carp croak);
use Bio::DB::Fasta;

$XML::Parser::EasyTree::Noempty = 1;

use vars qw($XRT_DB);

my $showView = param(view);
$showView ||= "LocusLink";  ## should be got from url

my $ids = param(id);
my @ids = split/\,|\s+/,$ids;

###################################################################
# if $CONF_DIR is empty before this point the setting of conf dir can
# be put in the file .tbconfidr which is at the same directory of the
# tbrowse script itself
#
if (!$CONF_DIR and (-e ".tbconfdir")) {
	my %OPTIONS = ();
	if (open F,".tbconfdir") {
		while (<F>) {
			next if /^\#/;
			chomp;
			$OPTIONS{$1} = $2 if /^(\w+)\s*=\s*(.+)/;
		}
		close F;
	}
	$CONF_DIR = $OPTIONS{conf_dir};
}
$CONF_DIR =~ s/^\s*//;
$CONF_DIR =~ s/$\s*//;
die "No CONF_DIR specified!" unless $CONF_DIR;
#
###################################################################

my $source = param(source);
my $confxml = "$CONF_DIR/$source.xview.xml";

croak "Specified source not found" unless (-e $confxml);

open(IN, "< $confxml");
my $xmlstr = "";
while (<IN>) { $xmlstr .= $_}
my $p = XML::Parser->new(Style=>'EasyTree');

my $xview = $p->parse($xmlstr);

my $viewConf;

foreach (@$xview) {
  croak "Wrong view definition" unless $_->{name} eq 'xrt_view';
  foreach (@{$_->{content}}) {
    if ($_->{name} eq 'xrt_db') {  ### xrt_db connection
      my $xrt_db = $_->{attrib}{xrt_db};
      my $host = $_->{attrib}{host};
      my $port = $_->{attrib}{port};
      my $user = $_->{attrib}{user};
      my $pass = $_->{attrib}{pass};
      my $dsn = "dbi:mysql:$xrt_db".(($host) ? ":$host" : "").(($port) ? ":$port" : "");
      $XRT_DB = Bio::DB::XRT->new(-dsn=>$dsn, -user=>$user, -pass=>$pass);

    } elsif ($_->{name} eq 'xview') {
      croak "No XRT db defined in the conf file!" unless $XRT_DB;

      my %v_settings = %{$_->{attrib}};
     
      my $view_id = $v_settings{id};
      next unless $view_id eq $showView;  # skip the ones not to show
      
      # some view settings
      my $view_width = $v_settings{width};

      $viewConf = $_->{content};

      ### some more view settings
      my $viewSettings = [];
      @$viewSettings = grep {$_->{name} ne 'xclass'} @$viewConf;
      foreach (@$viewSettings) {
        my $type = $_->{type};
        my $name = $_->{name};
        if ($type eq 'e') {
          $v_settings{$name} = $_->{content}->[0]->{content};
        }
      }

      my $bgcolor = $v_settings{bgcolor};
	  my $stylesheet = $v_settings{stylesheet} || '';

	  $stylesheet = "<link href='$stylesheet' rel='stylesheet' type='text/css' />" if $stylesheet;

      print header();
      print "<html xmlns='http://www.w3.org/1999/xhtml' lang='en-US'>
      <head>
        <title>BioXRT XViewer</title>
		$stylesheet
        </head>
        <body text='#000088'  bgcolor='$bgcolor'>
      ";

      print $v_settings{header}."\n" if $v_settings{header};   # output the header

      ### xclass conf
      my $xClassConf = [];
      ($xClassConf->[0]) = grep {$_->{name} eq 'xclass'} @$viewConf;  ## only get the first xclass (the rest will be ignored), because only one base xclass is allowed in one xview

      my ($class, $field) = split(/::/, ($v_settings{entry_field}||$v_settings{enter_field}));
      croak "Entry field is not defined in the view!" unless ($class and $field);

      foreach(@ids){
        my $id = $_;
        my $filter = [ [0, $field, $id, '='] ];
        my @refids = $XRT_DB->query_main_gref_by_keyword(-mclass=>$class, -filter=>$filter);
        print $v_settings{missing_id_message} ? "<p>$v_settings{missing_id_message}: <font color='red'>$_</font></p>\n" : "<p><font color='red'>Error: Wrong ID '$_', skipped!</font></p>\n" unless (@refids);
        foreach (@refids) {
          print "<table width='$view_width' border='0' cellpadding='0' cellspacing='0'><tr><td>\n";
          &classShow($xClassConf, [$_]) || print "<p><font color='red'>Error: Wrong definition in view '$view_id'</font></p>\n";
          print "</td></tr></table><br>\n";
        }
      }

      print $v_settings{footer}."\n" if $v_settings{footer};

      print "<p><i>This database is implemented using the <a href='http://projects.tcag.ca/bioxrt'>BioXRT</a> platform.</i><br><font size='2'>BioXRT XRT viewer version $VERSION</font></p>\n";

      last;
    }
  }
}

print "</body></html>\n"; 

croak "Specified view does not exist!" unless (ref $viewConf);


sub classShow {

  my $viewConf = shift;
  my $refids = shift;
  my $level = shift;

  my $leadingTab = "\t"x($level+1);
  my $leadingTabClass = "\t"x($level);

#  print "$leadingTab<table width='100%' border='0' cellpadding='0' cellspacing='0'><tr><td>\n";

  foreach (@$viewConf) {
    print "$leadingTab<table width='100%' border='0' cellpadding='0' cellspacing='0'><tr><td>\n";
    my $ref = $_;
    my $type = $ref->{name};
    return unless $type eq 'xclass';  # the most out layer should always be class

    my %c_settings = ();      ## keeps the xclass settings

    %c_settings = %{$ref->{attrib}};        ## settings of xclass in its xml attributes

    my $count = -1;
    foreach (@$refids) {      ## show each refid of the base class
      $count++;
      my $refid = $_;

      ### 
      return if ( $level == 0 && !$XRT_DB->simple_query(-class=>$c_settings{name}, -attribute=>"ID", -refid=>$refid) );

      my %a_settings = ();       ## settings of xattributes
      my @xattributes = ();      ## id(s) of xattributes to show

      my $content = $ref->{content};
      foreach (@$content) {   ## attributes to be shown of the base xclass
        my $attribRef = $_;
        my $type = $attribRef->{name};

        if ($type eq 'xattrib') {  ## this is an xattribute
        my $a_id = int(rand(100000000));
        while((grep {/^$a_id$/} keys(%a_settings)) or !$a_id){ $a_id = int(rand(100000000)) }
          $a_id = $attribRef->{attrib}{id} if $attribRef->{attrib}{id};
          push @xattributes, $a_id;
          # print "$a_id\n";

          $a_settings{$a_id} = $attribRef->{attrib};   ### settings of xattribute in its tag attributes

          my @content = @{ $_->{content} };  ## some more settings of the current xattribute (defined in sub-tag of the current xattribute), can override the prevous settings
          foreach (@content) {
            my $type = $_->{type};
            my $name = $_->{name} || 'name';
            my $value = ($type eq 't' and $name eq 'name') ? $_->{content} : $_->{content}->[0]->{content};
            $a_settings{$a_id}{$name} = $value;
          }

        } 
      }

      # now we have got all xattributes for the current xclass
      # 
      my %a_id2value = ();   ## keeps the value of each field
      foreach (@xattributes) {   ## get value of all normal fields
        my $name = $a_settings{$_}{name};
        next if ($name =~ /^\s*?sub\s*\{.*\}\s*$/s);  ## calculated field, we deal with it later
        my $aid = $XRT_DB->attribute2aid($name);
        unless ($aid) {   ## wrong attribute name
          warn "Wrong attribute name: $name";
          $_ = undef;     ## undef the wrong one
	      next;
        }
        my @value = $XRT_DB->simple_query(-class=>$c_settings{name}, -aid=>$aid, -refid=>$refid);  # get the value from XRT db
        $a_id2value{$_} = \@value;
      }

      @xattributes = grep { $_ } @xattributes;      ## remove the wrong xattributes

      # now we have got value for every normal fields

      ## post-process the data, calculating the user defined fields and adding the URLs
      foreach (@xattributes) {
        my @value = ();
        my $name = $a_settings{$_}{name}; 
        if ($name =~ /^\s*?sub\s*\{.*\}\s*$/gs) {  ## calculated field
          my $func = eval($name);
          @value = &$func(\%a_id2value);
          $a_settings{$_}{name} = "[Calculated Field]";   ## set its name
        } else {                                   ## normal field
          @value = @{$a_id2value{$_}};
        }

        # link setting
        my $link = $a_settings{$_}{link};
        if ($link =~ /^\s*?sub\s*\{.*\}\s*$/gs) {  ## calculated link
          my $func = eval($link);
          my @links = &$func(\%a_id2value);
          $link = \@links;
        } elsif ($link) {
          $link = [$link]
        }

        if (ref $link) {
          my $ii = 0;
          foreach (@value) {
            my $lnk = $link->[$ii] || $link->[0];
            my $url_encoded = uri_escape($_);
            $lnk =~ s/\*/$url_encoded/g;
            $_ = "<a href=\"$lnk\">$_</a>" if ($lnk);
            $ii++;
          }
        }

        $a_id2value{$_} = \@value;    ## put the processed value back into the hash
      }

      ##
      # start to output the current xclass
      # TODO: 
      # 1. create a layout attribute for the output - standrad or pack
      # 2. put the whole output into a table, so that we can control the width -DONE
      ##

      my $classLabel = ($c_settings{label} eq "0") ? "" : ($c_settings{label} || $c_settings{name}).": " ;
      my @primaryAttribValue = @{$a_id2value{$c_settings{primary_xattrib}}};
      unless ($count and $c_settings{layout} eq "pack") {
        print "$leadingTab\t<div style='margin-left:".(($level-1)*2+2)."em;'>";
        print "<b>$classLabel</b>"
	      .join(", ",@primaryAttribValue)."<br>";
        print "</div>\n";
      }

      my $delimiter = $c_settings{layout} eq "pack" ? " | " : "<br>"; 
      my @output = ();
      foreach (@xattributes) {   ## output attributes
        my $attribLabel = ($a_settings{$_}{label} eq "0") ? "" : ($a_settings{$_}{label} || $a_settings{$_}{name}).": ";
        my @value = @{$a_id2value{$_}};
        push @output, "<b>$attribLabel</b>".join(", ",@value) unless (!(@value) or $a_settings{$_}{hidden} or (@value==1 and $value[0] eq "") );
        $mm++;
      }
      my $output = join($delimiter, @output);
      print "$leadingTab\t<div style='margin-left:".(($level-1)*2+4)."em;'>$output</div>\n";

      ### end of output

      ### sub-classes
      foreach (@$content) {   ## sub-classes of the base class
        my $type = $_->{name};
        if ($type eq 'xclass') {  ## this is a sub-class
          my $childClassName = $_->{attrib}{name};
          ### get the refid(s) of the related child class
          my @c_refids = $XRT_DB->query_main_gref_by_keyword(-mclass=>$childClassName, -rclass=>$c_settings{name}, -attribute=>'ID', -exact=>1, -keyword=>$refid);
          &classShow([$_], \@c_refids, $level+1) if (@c_refids);  ## recursively call this function to go one level down
        }
      }

    }  # foreach @$refids

  print "$leadingTab</td></tr></table>\n";
  } # foreach @$viewConf
  #  print "$leadingTab</td></tr></table>\n";
  1;
}

=head1 AUTHOR

Junjun Zhang E<lt>junjun@genet.sickkids.on.caE<gt>.

Copyright (c) 2004 The Centre for Applied Genomics.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.  See DISCLAIMER for
disclaimers of warranty.

=cut

!NO!SUBS!
close OUT or die "Can't close $file: $!";
chmod 0755, $file or die "Can't reset permissions for $file: $!\n";
exec("$Config{'eunicefix'} $file") if $Config{'eunicefix'} ne ':';
