package GuessDirectories;

use Config;

# this package never gets installed - it's just used by Makefile.PL
sub conf {
  if ($^O =~ /mswin/i) {  # windows system
    for ('C:/Program Files/Apache Group/Apache2/conf',
	 'C:/Program Files/Apache Group/Apache/conf',
	 'C:/Apache/conf',
	 'C:/Apache2/conf') {
      return $_ if -d $_;
    }
  } else {
    for ('/usr/local/apache/conf',   # standard apache install
	 '/etc/httpd/conf',          # RedHat linux
	 '/etc/apache',              # Slackware linux
	 '/etc/httpd',               # MacOSX
	) {
      return $_ if -d $_;
    }
  }
  return;
}

sub htdocs {
  if ($^O =~ /mswin/i) {  # windows system
    for ('C:/Program Files/Apache Group/Apache2/htdocs',
	 'C:/Program Files/Apache Group/Apache/htdocs',
	 'C:/Apache/htdocs',
	 'C:/Apache2/htdocs') {
      return $_ if -d $_;
    }
  } else {
    for ('/usr/local/apache/htdocs',       # standard apache install
	 '/var/www/html',                  # RedHat linux
	 '/var/www/htdocs',                # Slackware linux
	 '/Library/Webserver/Documents',  # MacOSX
	) {
      return $_ if -d $_;
    }
  }
  return;
}

sub cgibin {
  if ($^O =~ /mswin/i) {  # windows system
    for ('C:/Program Files/Apache Group/Apache2/cgi-bin',
	 'C:/Program Files/Apache Group/Apache/cgi-bin',
	 'C:/Apache/cgi-bin',
	 'C:/Apache2/cgi-bin') {
      return $_ if -d $_;
    }
  } else {
    for ('/usr/local/apache/cgi-bin',      # standard apache install
	 '/var/www/cgi-bin',               # RedHat & Slackware linux
	 '/Library/Webserver/CGI-Executables',  # MacOSX
	) {
      return $_ if -d $_;
    }
  }
  return;
}

sub bin {
  my $startperl = $Config{startperl} ne '#!perl'
    ? $Config{startperl}
    : "#!$Config{perlpath}";
  $startperl =~ s/^#!//;
  $startperl =~ s/\/perl$//;
  return $startperl if -d $startperl;
  return;
}

sub lib {
  my @MyINC1 = grep { !/^\./ } @INC;
  my @MyINC2 = grep { /local/ and /site/ } @MyINC1;
  my @MyINC3 = grep { /local/ } @MyINC1;
  my @MyINC4 = grep { /lib/ } @MyINC1;
  return $MyINC2[0] || $MyINC3[0] || $MyINC4[0] || $MyINC1[0];
}

1;
